/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.TimeBase;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;

public class StopWatchParameter
extends ProtectionParameter {
    private static final long serialVersionUID = -1208530569990595338L;
    protected static final transient int READY = 0;
    protected static final transient int WAITING = 1;
    protected static final transient int RUNNING = 2;
    protected static final transient int MAX_OUTPUT_TIME = 65535;
    protected TimeBase fOutputTimeBase = null;
    protected transient long fLapTime;
    protected transient long fCurrentTime;
    protected transient long fLastCurrentTime;
    protected transient int fCurrentState;
    protected transient Timer fCurrentTimer;
    protected transient long fOutputTime;
    protected transient boolean fLastLap = false;

    public StopWatchParameter() {
        this.setRemanenceAvailable(true);
        this.fOutputTimeBase = new TimeBase(2);
    }

    public StopWatchParameter(Block block) {
        super(block);
        this.setRemanenceAvailable(true);
        this.fOutputTimeBase = new TimeBase(2);
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.fLapTime = 0L;
            this.fCurrentTime = 0L;
            this.fLastCurrentTime = 0L;
            this.fOutputTime = 0L;
            this.fCurrentState = 0;
            this.getCurrentTimer().init(interpreter);
            this.getCurrentTimer().finish();
        }
    }

    public long calculateAnalogValue(boolean en, boolean lap, boolean reset) {
        if (reset) {
            this.resetParmeter();
            this.fCurrentParameterText = this.calculateCurrentParameterText();
            return this.fOutputTime;
        }
        if (en && this.fOutputTime < 65535L) {
            if (this.fCurrentState == 0) {
                this.getCurrentTimer().start();
                this.fCurrentState = 2;
            }
            if (this.fCurrentState == 1) {
                this.getCurrentTimer().start();
                this.fCurrentState = 2;
            }
            if (this.fCurrentState == 2) {
                // empty if block
            }
        }
        if (!en || this.fOutputTime >= 65535L) {
            this.fLastCurrentTime = this.fCurrentTime;
            this.fCurrentState = 1;
            this.getCurrentTimer().reset();
        }
        this.fCurrentTime = this.fLastCurrentTime + this.fOutputTimeBase.getTimeValueByBase(this.getCurrentTimer().getPassedTime().getMilliseconds());
        if (en && lap && !this.fLastLap) {
            this.fLapTime = this.fCurrentTime;
        }
        this.fOutputTime = lap ? this.fLapTime : this.fCurrentTime;
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        this.fLastLap = lap;
        return this.fOutputTime;
    }

    public String getParameterText() {
        StringBuffer result = new StringBuffer();
        String remText = "";
        if (this.getRemanenceAvailable()) {
            remText = this.getRemanenceObject().getParameterText();
        }
        if (remText.length() > 0) {
            result.append(remText);
            result.append("\n");
        }
        result.append("TB = ");
        result.append(this.fOutputTimeBase.getTimeBaseAbbreviation());
        result.append(this.getProtectionSign());
        return result.toString();
    }

    protected String calculateCurrentParameterText() {
        StringBuffer result = new StringBuffer();
        String timeStr = "";
        result.append("CurT=");
        timeStr = String.valueOf(this.fCurrentTime);
        result.append(Util.addLeadingSpaces(timeStr, 5));
        result.append("\n");
        result.append("LapT=");
        timeStr = String.valueOf(this.fLapTime);
        result.append(Util.addLeadingSpaces(timeStr, 5));
        result.append("\n");
        result.append("OutT=");
        timeStr = String.valueOf(this.fOutputTime);
        result.append(Util.addLeadingSpaces(timeStr, 5));
        this.fireParameterUpdateEvent();
        return result.toString();
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fOutputTimeBase = (TimeBase)dr.readStorable();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fOutputTimeBase);
    }

    public Timer getCurrentTimer() {
        if (this.fCurrentTimer == null) {
            this.setCurrentTimer(new Timer(new HighResolutionSeconds()));
            this.fCurrentTimer.getParamTime().setMilliseconds(Long.MAX_VALUE);
        }
        return this.fCurrentTimer;
    }

    public void setCurrentTimer(Timer newTimer) {
        this.fCurrentTimer = newTimer;
    }

    public TimeBase getOutputTimeBase() {
        return this.fOutputTimeBase;
    }

    public void setOutputTimeBase(TimeBase outputTimeBase) {
        this.fOutputTimeBase = outputTimeBase;
    }

    public long getOutputTime() {
        return this.fOutputTime;
    }

    public long getCurrentTime() {
        return this.fCurrentTime;
    }

    public long getLapTime() {
        return this.fLapTime;
    }

    public void resetParmeter() {
        this.fLapTime = 0L;
        this.fLastLap = false;
        this.fCurrentTime = 0L;
        this.fLastCurrentTime = 0L;
        this.fOutputTime = 0L;
        this.fCurrentState = 0;
        this.getCurrentTimer().finish();
    }

    public void fireParameterSetEvent(String message) {
        super.fireParameterSetEvent(message);
        this.resetParmeter();
    }
}

